<%--
 This is an error page delivered by the TaskInterface servlet when the incoming
 browser request appears syntactically invalid.  In some cases, it is returned
 if the request is semantically invalid, such as referring to an unknown task
 identifier.  It will display an error message describing the problem (with the
 error message text being non-translated), and provide a button that can be
 used to close the window, on the assumption that it's a task window.  When the
 user has finished viewing the error message, they will click on the Close
 button, which will close the task window.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <hmc:title><fmt:message key="badRequestTitle"/></hmc:title>
   <link href="/skin/HMCskin.css" rel="stylesheet" type="text/css"/>
   <link rel="stylesheet" type="text/css" href="/css/fw/hmc.css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
   <script type="text/javascript" src="/js/task/taskWindow.js"></script>

   <script type="text/javascript">
      function closeButton() {
         window.close();
      }

      // Stop anybody from watching this window any longer
      mw = getHMCMainWindow(window);
      if (mw != null)
         mw.markWindowCloseHandled(window.name);
      window.onunload = "";

      // Make sure the message can be read
      minWidth  = <fmt:message key="badRequestWindowWidth"/>;
      minHeight = <fmt:message key="badRequestWindowHeight"/>;

      // Since this request may not have come from a task window, don't mess
      // with the window size if it's unnecessary.
      if ("outerWidth" in window && "outerHeight" in window &&
          window.outerWidth >= minWidth && window.outerHeight >= minHeight) {
         // Leave window size as is
      } else {
         window.resizeTo(minWidth, minHeight);
      }
   </script>
</head>
<body class="errorPage">
<span class="cont1">
<h1><fmt:message key="badRequestTitle"/></h1>
<p><fmt:message key="badRequestMessage"/></p>
<p><c:out value="${errorMessage}"/></p>
<form>
   <input type="button" onclick="closeButton()" value="<fmt:message key='closeButtonLabel'/>"
          class="b1" onmouseout="className='b1'"
          onmouseover="className='b2'" />
</form>
</span>
</body>
</html>
</fmt:bundle>
